<?php
// deactivategmapkey.php

include '../include/conn.php'; // DB connection file

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Step 1: Get and validate input
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['key']) || empty(trim($input['key']))) {
    echo json_encode([
        "status" => false,
        "message" => "License key is required."
    ]);
    exit;
}

$key = trim($input['key']);

// Step 2: Check DB connection
if ($conn->connect_error) {
    echo json_encode([
        "status" => false,
        "message" => "Database connection failed: " . $conn->connect_error
    ]);
    exit;
}

// Step 3: Check if key exists and is active
$checkStmt = $conn->prepare("SELECT id FROM license_keys WHERE license_key = ? AND is_active = 1 LIMIT 1");
$checkStmt->bind_param("s", $key);
$checkStmt->execute();
$result = $checkStmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        "status" => false,
        "message" => "License key not found or already deactivated."
    ]);
    $checkStmt->close();
    $conn->close();
    exit;
}

// Step 4: Deactivate the key
// $updateStmt = $conn->prepare("UPDATE license_keys SET is_active = 1 WHERE license_key = ?");
// $updateStmt->bind_param("s", $key);

// if ($updateStmt->execute()) {
//     echo json_encode([
//         "status" => true,
//         "message" => "License key successfully deactivated."
//     ]);
// } else {
//     echo json_encode([
//         "status" => false,
//         "message" => "Failed to deactivate license key."
//     ]);
// }

// Cleanup
$checkStmt->close();
$updateStmt->close();
$conn->close();
